/************************************************************************
	_CAPI.C

	Copyright (c) 1996-2001 Datalight, Inc.
	Confidential and Proprietary
	All Rights Reserved

	Provides the compiler specific portions of the CAPI module.

	History:
	     04/19/2001 jmb changed ISR_ROUTINE to _loadds
	     03/20/2001 jmb Added FindSocketsVector to search the vector table
		                 for the Sockets kernel.  We look for the string
							  "TCPTSR" to verify that Sockets is in memory.  
							  I removed the code that checked the interrupt 
							  vector for a non-zero value.
	     03/16/2001 jmb added check for actual interrupt vector being set
	                    changed error check on return from Sockets api 
	                    to check cflag rather than use flags which is not
	                    available in MSVC.  I also modified the definition
	                    of AsyncNotificationHandler to compile under either
	                    SDTK or MSVC.
	1.01 2000-12-09 pkg Factored out non portable code
	1.00 2000-09-08 pkg Created
 ************************************************************************/

#include <dos.h>
#include "compiler.h"
#include "capi.h"

/*
	Prototypes
*/
int FindSocketsVector(void);

/*
	Stack size of stack for asynchronous callbacks
*/
#define HANDLER_STACK_SIZE 500

/*
	The following global is used to tell the CallSocketsDosApi()
	function what interrupt the Sockets stack is hooking.  By
	default this is 0x61 unless overidden on the command line
	load of SOCKETM or SOCKETSP.
*/
int iSocketsApiInterrupt = 0x00;


/*
	Parameters
	px86Regs, pointer to an X86Regs structure which holds the
	registers to call the Sockets interrupt with.  This structure
	is updated with the new register values after the Sockets
	interrupt is made.
	Description
	Calls the Sockets kernel via a software interrupt described
	by iSocketsApiInterrupt with the registers defined in the
	X86Regs structure.
	Returns
	On success, ax value returned by the Sockets call.
	On error (carry flag set), -1 if the Sockets API is not found
*/
int CallSocketsDosApi(X86Regs * px86regs)
{
	union REGS  r;
	struct SREGS s;

	/* Clear the current error status */
	iNetErrNo = iNetSubErrNo = 0;

	/* Make certain the sockets interrupt is set */
	if (iSocketsApiInterrupt == 0)
	{
		iSocketsApiInterrupt = FindSocketsVector();
		if (iSocketsApiInterrupt == 0)
		{
			iNetErrNo = ERR_API_NOT_LOADED;
			return -1;
		}
	}

	/*
		Call the sockets interrupt with the appropriate
		registers setup for the sockets API
	*/
	r.x.ax = px86regs->ax;
	r.x.bx = px86regs->bx;
	r.x.cx = px86regs->cx;
	r.x.dx = px86regs->dx;
	r.x.si = px86regs->si;
	r.x.di = px86regs->di;

	s.ds = px86regs->ds;
	s.es = px86regs->es;

	int86x(iSocketsApiInterrupt, &r, &r, &s);

	px86regs->ax = r.x.ax;
	px86regs->bx = r.x.bx;
	px86regs->cx = r.x.cx;
	px86regs->dx = r.x.dx;
	px86regs->si = r.x.si;
	px86regs->di = r.x.di;

	px86regs->ds = s.ds;
	px86regs->es = s.es;


	/*
		Any erros are reported with a carry flag set and the
		network error is in the low eight bits and any
		sub-error codes are in the upper eight bits
	*/
	if (r.x.cflag)
	{
		iNetErrNo = px86regs->ax & 0x00FF;
		iNetSubErrNo = px86regs->ax >> 8;
		return -1;
	}
	else
	{
		return px86regs->ax;
	}
}



typedef int (far *FH)(int,int,DWORD);


int _loadds D_FAR AsyncNotificationHandler(void)
{
	static int iSocket, iEvent;
	static WORD wArgLo, wArgHi, wHintLo, wHintHi;
	static DWORD dwArg;
	static FH Handler;
	static int iSaveSS, iSaveSP;
	static char rgcStack[HANDLER_STACK_SIZE];
	static int iStackPointer;
	static int iSaveNetErrNo, iSaveNetSubErrNo;

	iStackPointer = (int)rgcStack + HANDLER_STACK_SIZE - 10;

	asm {

		// It is safe to use local variables as async notifications don't nest
		// We can safely ignore BP as long as we do not use any auto variables
		// Save arguments in registers into local variables
		mov     iSocket,bx;
		mov     iEvent,cx;
		mov     wArgLo,dx;
		mov     wArgHi,si;
		mov     wHintHi,es;
		mov     wHintLo,di;

		// Save stack registers
		mov     iSaveSS,ss;
		mov     iSaveSP,sp;

		// Switch stack to local stack
		mov     ax,ds;
		mov     ss,ax
		mov   sp,iStackPointer;
	}

	// Save the error variables just incase we interrupted while they have
	// been set, but not used yet and our user calls CAPI.

	iSaveNetErrNo = iNetErrNo;
	iSaveNetSubErrNo = iNetSubErrNo;

	((WORD *)&Handler)[0] = wHintLo;
	((WORD *)&Handler)[1] = wHintHi;
	((WORD *)&dwArg)[0] = wArgLo;
	((WORD *)&dwArg)[1] = wArgHi;

	(*Handler)(iSocket,iEvent, dwArg);

	asm {
		// Restore stack registers
		mov     ss,iSaveSS;
		mov     sp,iSaveSP;
	}

	// resore error variables
	iNetErrNo = iSaveNetErrNo;
	iNetSubErrNo = iSaveNetSubErrNo;
	return 0;
}


/*
 *----------------------------------------------------------------------------
 * $DocProc: FindSocketsVector
 *
 * OnEntry
 *   Nothing
 *
 * OnExit
 *   returns SOCKETS vector number or 0 if not found.
 *
 * Modifies
 *   none
 *
 *---------------------------------------------------------------------------- 
 */
int FindSocketsVector()
{
	void (interrupt *piAPIInterruptVector)();
	static char cSockTSRID[] = "TCPTSR";
	int iAPIInterrupt, i;
	char far *pTSRID;

	for (iAPIInterrupt = 0x20; iAPIInterrupt < 0x100; iAPIInterrupt++) 
	{
		piAPIInterruptVector = _dos_getvect(iAPIInterrupt);

		if (piAPIInterruptVector == 0)
			continue;

		pTSRID = (char far *)piAPIInterruptVector + 3;
		for (i = 0; i < 6; i++) 
		{
			if (pTSRID[i] != cSockTSRID[i])
				break;
		}
		if (i == 6)
			break;
	}
	if (iAPIInterrupt == 0x100) 
		iAPIInterrupt = 0;
	return iAPIInterrupt;
}

